#include <hidef.h>      // for EnableInterrupts macro
#include "derivative.h" // include peripheral declarations
#include "sci.h"

void init_SCI(void)
{
#if SCI1  
  SCI1C1 = 0x13;               // 1 start, 8 data, odd parity, 1 stop
  SCI1C3 = 0x00;               // Disable error interrupts
  SCI1S2 = 0x00;                
  SCI1C2 = 0x00;               // Disable all interrupts
  SCI1BDH = 0x01;              // 
  SCI1BDL = 0x04;              // Set baud rate to 4800 when Bus = 20MHz
  //SCI1BDH = 0x00;              // 
  //SCI1BDL = 0x0B;              // Set baud rate to 115200 when Bus = 20MHz
  SCI1C2 = SCI1C2_TE_MASK | SCI1C2_RE_MASK;     // Enable Tx and Rx
#elif SCI2
  SCI2C1 = 0x13;               // 1 start, 8 data, odd parity, 1 stop
  SCI2C3 = 0x00;               // Disable error interrupts
  SCI2S2 = 0x00;                
  SCI2C2 = 0x00;               // Disable all interrupts
  SCI2BDH = 0x01;              // 
  SCI2BDL = 0x04;              // Set baud rate to 4800 when Bus = 20MHz
//SCI2BDH = 0x00;              // 
//SCI2BDL = 0x0B;              // Set baud rate to 115200 when Bus = 20MHz
  SCI2C2 = SCI2C2_TE_MASK | SCI2C2_RE_MASK;     // Enable Tx and Rx

#endif
}

byte sci_getchar(byte * time_out)
{
   TPM1CNTH = 0;           // reset counter
#if SCI1
   while(!SCI1S1_RDRF)
   {
     if(TPM1C0SC_CH0F)         // 3.5T reached
     {
       TPM1C0SC_CH0F = 0;      // clear flag
       *time_out = 1;
       break;
     }
     __RESET_WATCHDOG();
   };
   (void) SCI1S1;
   (void) SCI1C3;
   return SCI1D;
#elif SCI2
   while(!SCI2S1_RDRF)
   {
     if(TPM1C0SC_CH0F)         // 3.5T reached
     { 
       TPM1C0SC_CH0F = 0;      // clear flag
       *time_out = 1;
       break;
     }     
     __RESET_WATCHDOG();
   };
   (void) SCI2S1;
   (void)SCI2C3;
   return SCI2D;
#endif   
}

byte sci_puthar(char Chr)
{
#if SCI1

  while(!SCI1S1_TDRE)
    __RESET_WATCHDOG();
  
  SCI1D = (byte)Chr;              // Store char to the transmitter register
  while(!SCI1S1_TC)
    __RESET_WATCHDOG();
    
  return 0;

#elif SCI2

  while(!SCI2S1_TDRE)
    __RESET_WATCHDOG();
  
  SCI2D = (byte)Chr;              // Store char to the transmitter register
  while(!SCI2S1_TC)
    __RESET_WATCHDOG();
    
  return 0;

#endif  
}



